<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class HashtagBuilder implements InterfaceHashtagSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitHashtagSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            HashtagTable::DISPLAY_TEXT       => '',
            HashtagTable::CACHE_POSTS_COUNT  => '0',
            HashtagTable::STAMP_REGISTRATION => System::isoDateTime(),
            HashtagTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): HashtagModel
    {
        return HashtagModel::createFromData(
            array(
                // display text

                HashtagTable::DISPLAY_TEXT       => $this -> displayText

                ?? $this -> defaultValues[HashtagTable::DISPLAY_TEXT],

                // cache posts count

                HashtagTable::CACHE_POSTS_COUNT  => $this -> cachePostsCount

                ?? $this -> defaultValues[HashtagTable::CACHE_POSTS_COUNT],

                // stamp registration

                HashtagTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[HashtagTable::STAMP_REGISTRATION],

                // stamp last update

                HashtagTable::STAMP_LAST_UPDATE  => $this -> stampLastUpdate

                ?? $this -> defaultValues[HashtagTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
